/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.itemstats;

import net.runelite.api.Client;
import net.runelite.client.plugins.itemstats.Positivity;
import net.runelite.client.plugins.itemstats.RangeStatChange;
import net.runelite.client.plugins.itemstats.SingleEffect;
import net.runelite.client.plugins.itemstats.StatBoost;
import net.runelite.client.plugins.itemstats.StatChange;

public class RangeStatBoost
extends SingleEffect {
    private final StatBoost a;
    private final StatBoost b;

    RangeStatBoost(StatBoost a2, StatBoost b2) {
        assert (a2.getStat() == b2.getStat());
        this.a = a2;
        this.b = b2;
    }

    @Override
    public StatChange effect(Client client2) {
        StatChange changeA = this.a.effect(client2);
        StatChange changeB = this.b.effect(client2);
        RangeStatChange r2 = new RangeStatChange();
        r2.setMinAbsolute(Math.min(changeA.getAbsolute(), changeB.getAbsolute()));
        r2.setAbsolute(Math.max(changeA.getAbsolute(), changeB.getAbsolute()));
        r2.setMinRelative(Math.min(changeA.getRelative(), changeB.getRelative()));
        r2.setRelative(Math.max(changeA.getRelative(), changeB.getRelative()));
        r2.setMinTheoretical(Math.min(changeA.getTheoretical(), changeB.getTheoretical()));
        r2.setTheoretical(Math.max(changeA.getTheoretical(), changeB.getTheoretical()));
        r2.setStat(changeA.getStat());
        int avg = (changeA.getPositivity().ordinal() + changeB.getPositivity().ordinal()) / 2;
        r2.setPositivity(Positivity.values()[avg]);
        return r2;
    }
}

